/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.client;

import com.lycanitesmobs.client.localisation.LanguageManager;
import com.lycanitesmobs.core.entity.ExtendedPlayer;
import com.lycanitesmobs.core.info.ItemManager;
import com.lycanitesmobs.core.item.special.ItemSoulgazer;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.MobEffects;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.RenderBlockOverlayEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ClientEventListener {
    public static int ITEM_RENDER_MODE = 0;

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onRenderHand(RenderHandEvent event) {
        ITEM_RENDER_MODE = 1;
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onRenderHand(RenderGameOverlayEvent event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.EXPERIENCE) {
            ITEM_RENDER_MODE = 2;
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onRenderWorldLast(RenderWorldLastEvent event) {
        ITEM_RENDER_MODE = 1;
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onFogDensity(EntityViewRenderEvent.FogDensity event) {
        if (!(event.getEntity() instanceof EntityLivingBase)) {
            return;
        }
        EntityLivingBase entityLiving = (EntityLivingBase)event.getEntity();
        if (event.getState().func_185904_a() == Material.field_151587_i && (!event.getEntity().func_70027_ad() || entityLiving.func_70644_a(MobEffects.field_76426_n))) {
            event.setDensity(0.5f);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onBlockOverlay(RenderBlockOverlayEvent event) {
        if (event.getBlockForOverlay().func_185904_a() == Material.field_151581_o && (!event.getPlayer().func_70027_ad() || event.getPlayer().func_70644_a(MobEffects.field_76426_n))) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onItemTooltip(ItemTooltipEvent event) {
        ExtendedPlayer extendedPlayer;
        int sharpness = ItemManager.getInstance().getEquipmentSharpnessRepair(event.getItemStack());
        int mana = ItemManager.getInstance().getEquipmentManaRepair(event.getItemStack());
        if (sharpness > 0 || mana > 0) {
            event.getToolTip().add(LanguageManager.translate("equipment.item.repair"));
            if (sharpness > 0) {
                event.getToolTip().add(LanguageManager.translate("equipment.sharpness") + " " + sharpness);
            }
            if (mana > 0) {
                event.getToolTip().add(LanguageManager.translate("equipment.mana") + " " + mana);
            }
        }
        if (event.getItemStack().func_77973_b() instanceof ItemSoulgazer && (extendedPlayer = ExtendedPlayer.getForPlayer(event.getEntityPlayer())) != null && extendedPlayer.creatureStudyCooldown > 0) {
            event.getToolTip().add(LanguageManager.translate("message.beastiary.study.cooldown") + " " + String.format("%.0f", Float.valueOf((float)extendedPlayer.creatureStudyCooldown / 20.0f)) + "s");
        }
    }
}

